package gov.va.vamf.scheduling.batch.datalayer.reminder;

import com.agilex.healthcare.directscheduling.dao.DAOConstants;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.object.StoredProcedure;

import java.sql.Types;
import java.util.Map;

public class RecallReminderStoredProcedure extends StoredProcedure {

	public RecallReminderStoredProcedure(JdbcTemplate jdbcTemplate, String storedProcedureString,
										 RecallReminderResultSetRowMapper recallReminderResultSetRowMapper) {

		super(jdbcTemplate, storedProcedureString);

		declareParameter(new SqlReturnResultSet(DAOConstants.RESULT_LIST, recallReminderResultSetRowMapper));

		declareParameter(new SqlParameter(DAOConstants.RECALL_DATE, Types.DATE));
		compile();
	}

	public Map<String, Object> getStoredProcedureResults(Map<String, Object> inParameters) {
		return execute(inParameters);
	}
}
